/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.rdp5.cliprdr;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ClipBMP
extends Component {
    protected static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Input == null ? (class$net$propero$rdp$Input = ClipBMP.class$("net.propero.rdp.Input")) : class$net$propero$rdp$Input));
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private OutputStream fo;
    static /* synthetic */ Class class$net$propero$rdp$Input;

    public byte[] getBitmapAsBytes(Image image, int n, int n2) {
        try {
            this.fo = new ByteArrayOutputStream();
            this.save(image, n, n2);
            this.fo.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ((ByteArrayOutputStream)this.fo).toByteArray();
    }

    public void saveBitmap(String string, Image image, int n, int n2) {
        try {
            this.fo = new FileOutputStream(string);
            this.save(image, n, n2);
            this.fo.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void save(Image image, int n, int n2) {
        try {
            this.convertImage(image, n, n2);
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean convertImage(Image image, int n, int n2) {
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        int n3 = (4 - n * 3 % 4) * n2;
        this.biSizeImage = n * n2 * 3 + n3;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = n;
        this.biHeight = n2;
        return true;
    }

    private void writeBitmap() {
        int n;
        byte[] byArray = new byte[3];
        int n2 = this.biWidth * this.biHeight - 1;
        int n3 = 4 - this.biWidth * 3 % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = n = n2 - this.biWidth;
        try {
            for (int i = 0; i < n2; ++i) {
                int n7 = this.bitmap[n];
                byArray[0] = (byte)(n7 & 0xFF);
                byArray[1] = (byte)(n7 >> 8 & 0xFF);
                byArray[2] = (byte)(n7 >> 16 & 0xFF);
                this.fo.write(byArray);
                if (n4 == this.biWidth) {
                    n5 += n3;
                    for (int j = 1; j <= n3; ++j) {
                        this.fo.write(0);
                    }
                    n4 = 1;
                    n6 = n = n6 - this.biWidth;
                } else {
                    ++n4;
                }
                ++n;
            }
            this.bfSize += n5 - n3;
            this.biSizeImage += n5 - n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static Image loadbitmap(InputStream inputStream) {
        try {
            Image image;
            int n = 40;
            byte[] byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            int n2 = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            int n3 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
            int n4 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
            int n5 = (byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF;
            int n6 = (byArray[15] & 0xFF) << 8 | byArray[14] & 0xFF;
            int n7 = byArray[19] << 24 | byArray[18] << 16 | byArray[17] << 8 | byArray[16];
            int n8 = (byArray[23] & 0xFF) << 24 | (byArray[22] & 0xFF) << 16 | (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
            int n9 = (byArray[27] & 0xFF) << 24 | (byArray[26] & 0xFF) << 16 | (byArray[25] & 0xFF) << 8 | byArray[24] & 0xFF;
            int n10 = (byArray[31] & 0xFF) << 24 | (byArray[30] & 0xFF) << 16 | (byArray[29] & 0xFF) << 8 | byArray[28] & 0xFF;
            int n11 = (byArray[35] & 0xFF) << 24 | (byArray[34] & 0xFF) << 16 | (byArray[33] & 0xFF) << 8 | byArray[32] & 0xFF;
            int n12 = (byArray[39] & 0xFF) << 24 | (byArray[38] & 0xFF) << 16 | (byArray[37] & 0xFF) << 8 | byArray[36] & 0xFF;
            if (n6 == 24) {
                int n13 = n8 / n4 - n3 * 3;
                int[] nArray = new int[n4 * n3];
                byte[] byArray2 = new byte[(n3 + n13) * 3 * n4];
                inputStream.read(byArray2, 0, (n3 + n13) * 3 * n4);
                int n14 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        nArray[n3 * (n4 - i - 1) + j] = 0xFF000000 | (byArray2[n14 + 2] & 0xFF) << 16 | (byArray2[n14 + 1] & 0xFF) << 8 | byArray2[n14] & 0xFF;
                        n14 += 3;
                    }
                    n14 += n13;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
            } else if (n6 == 16) {
                int n15;
                int n16 = 0;
                n16 = n11 > 0 ? n11 : 1 << n6;
                if (n8 == 0) {
                    n8 = (n3 * n6 + 31 & 0xFFFFFFE0) >> 3;
                    n8 *= n4;
                }
                int[] nArray = new int[n16];
                byte[] byArray3 = new byte[n16 * 4];
                inputStream.read(byArray3, 0, n16 * 4);
                int n17 = 0;
                for (n15 = 0; n15 < n16; ++n15) {
                    nArray[n15] = 0xFF000000 | (byArray3[n17 + 2] & 0xFF) << 16 | (byArray3[n17 + 1] & 0xFF) << 8 | byArray3[n17] & 0xFF;
                    n17 += 4;
                }
                n15 = n8 / n4 - n3;
                int[] nArray2 = new int[n3 * n4];
                byte[] byArray4 = new byte[(n3 + n15) * n4];
                inputStream.read(byArray4, 0, (n3 + n15) * n4);
                n17 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        nArray2[n3 * (n4 - i - 1) + j] = nArray[byArray4[n17] & 0xFF] | nArray[byArray4[n17 + 1] & 0xFF] << 8;
                        n17 += 2;
                    }
                    n17 += n15;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n4, nArray2, 0, n3));
            } else if (n6 == 8) {
                int n18;
                int n19 = 0;
                n19 = n11 > 0 ? n11 : 1 << n6;
                if (n8 == 0) {
                    n8 = (n3 * n6 + 31 & 0xFFFFFFE0) >> 3;
                    n8 *= n4;
                }
                int[] nArray = new int[n19];
                byte[] byArray5 = new byte[n19 * 4];
                inputStream.read(byArray5, 0, n19 * 4);
                int n20 = 0;
                for (n18 = 0; n18 < n19; ++n18) {
                    nArray[n18] = 0xFF000000 | (byArray5[n20 + 2] & 0xFF) << 16 | (byArray5[n20 + 1] & 0xFF) << 8 | byArray5[n20] & 0xFF;
                    n20 += 4;
                }
                n18 = n8 / n4 - n3;
                int[] nArray3 = new int[n3 * n4];
                byte[] byArray6 = new byte[(n3 + n18) * n4];
                inputStream.read(byArray6, 0, (n3 + n18) * n4);
                n20 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        nArray3[n3 * (n4 - i - 1) + j] = nArray[byArray6[n20] & 0xFF];
                        ++n20;
                    }
                    n20 += n18;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n4, nArray3, 0, n3));
            } else if (n6 == 4) {
                int n21;
                int n22 = 0;
                n22 = n11 > 0 ? n11 : 1 << n6;
                if (n8 == 0) {
                    n8 = (n3 * n6 + 31 & 0xFFFFFFE0) >> 3;
                    n8 *= n4;
                }
                int[] nArray = new int[n22 + 1];
                byte[] byArray7 = new byte[n22 * 4];
                inputStream.read(byArray7, 0, n22 * 4);
                int n23 = 0;
                for (n21 = 0; n21 < n22; ++n21) {
                    nArray[n21] = 0xFF000000 | (byArray7[n23 + 2] & 0xFF) << 16 | (byArray7[n23 + 1] & 0xFF) << 8 | byArray7[n23] & 0xFF;
                    n23 += 4;
                }
                n21 = n8 * 2 / n4 - n3;
                if (n21 == 4) {
                    n21 = 0;
                }
                int[] nArray4 = new int[n3 * n4];
                byte[] byArray8 = new byte[(n3 / 2 + n21) * n4];
                inputStream.read(byArray8, 0, (n3 / 2 + n21) * n4);
                n23 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3 - 1; j += 2) {
                        nArray4[n3 * (n4 - i - 1) + j] = nArray[byArray8[n23] & 0xF];
                        nArray4[n3 * (n4 - i - 1) + j + 1] = nArray[(byArray8[n23] & 0xF0) / 15];
                        System.out.print("1:" + (byArray8[n23] & 0xF) + "\t");
                        System.out.print("2:" + (byArray8[n23] & 0xF0) / 15 + "\t");
                        ++n23;
                    }
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n4, nArray4, 0, n3));
            } else {
                logger.warn((Object)"Not a 24-bit or 8-bit Windows Bitmap, aborting...");
                image = null;
            }
            inputStream.close();
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

