/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.rdp5;

import net.propero.rdp.OrderException;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.Rdp;
import net.propero.rdp.RdpPacket;
import net.propero.rdp.RdpPacket_Localised;
import net.propero.rdp.crypto.CryptoException;
import net.propero.rdp.rdp5.VChannel;
import net.propero.rdp.rdp5.VChannels;

public class Rdp5
extends Rdp {
    private VChannels channels;

    public Rdp5(VChannels vChannels) {
        super(vChannels);
        this.channels = vChannels;
    }

    public void rdp5_process(RdpPacket_Localised rdpPacket_Localised, boolean bl) throws RdesktopException, OrderException, CryptoException {
        this.rdp5_process(rdpPacket_Localised, bl, false);
    }

    public void rdp5_process(RdpPacket_Localised rdpPacket_Localised, boolean bl, boolean bl2) throws RdesktopException, OrderException, CryptoException {
        Rdp.logger.debug((Object)"Processing RDP 5 order");
        if (bl) {
            rdpPacket_Localised.incrementPosition(bl2 ? 6 : 7);
            byte[] byArray = new byte[rdpPacket_Localised.size() - rdpPacket_Localised.getPosition()];
            rdpPacket_Localised.copyToByteArray(byArray, 0, rdpPacket_Localised.getPosition(), byArray.length);
            byte[] byArray2 = this.SecureLayer.decrypt(byArray);
        }
        while (rdpPacket_Localised.getPosition() < rdpPacket_Localised.getEnd()) {
            int n = rdpPacket_Localised.get8();
            int n2 = rdpPacket_Localised.getLittleEndian16();
            int n3 = rdpPacket_Localised.getPosition() + n2;
            Rdp.logger.debug((Object)("RDP5: type = " + n));
            switch (n) {
                case 0: {
                    int n4 = rdpPacket_Localised.getLittleEndian16();
                    this.orders.processOrders(rdpPacket_Localised, n3, n4);
                    break;
                }
                case 1: {
                    rdpPacket_Localised.incrementPosition(2);
                    this.processBitmapUpdates(rdpPacket_Localised);
                    break;
                }
                case 2: {
                    rdpPacket_Localised.incrementPosition(2);
                    this.processPalette(rdpPacket_Localised);
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    this.process_null_system_pointer_pdu(rdpPacket_Localised);
                    break;
                }
                case 6: {
                    break;
                }
                case 9: {
                    this.process_colour_pointer_pdu(rdpPacket_Localised);
                    break;
                }
                case 10: {
                    this.process_cached_pointer_pdu(rdpPacket_Localised);
                    break;
                }
                default: {
                    Rdp.logger.warn((Object)("Unimplemented RDP5 opcode " + n));
                }
            }
            rdpPacket_Localised.setPosition(n3);
        }
    }

    void rdp5_process_channel(RdpPacket_Localised rdpPacket_Localised, int n) {
        VChannel vChannel = this.channels.find_channel_by_channelno(n);
        if (vChannel != null) {
            try {
                vChannel.process((RdpPacket)rdpPacket_Localised);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

