/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.loader;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import net.propero.rdp.OrderException;
import net.propero.rdp.Rdesktop;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.Utilities;

public class JRdpLoader {
    private static String[] identifiers = new String[]{"--user", "--password", "--domain", "--fullscreen", "--geometry", "--use_rdp5"};
    private static String[] pairs = new String[]{"-u", "-p", "-d", "-f", "-g", "--use_rdp5"};

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.err.println("Expected usage: JRdpLoader launchFile");
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = "";
        String string3 = "";
        try {
            String[] stringArray2;
            String string4 = "";
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() != 0) {
                stringArray2 = dataInputStream.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string5 = stringTokenizer.nextToken();
                String string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = string6 + stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string6 = string6 + " ";
                }
                if (string5.equals("--server")) {
                    string2 = string6;
                    continue;
                }
                if (string5.equals("--port")) {
                    string3 = string6;
                    continue;
                }
                String string7 = JRdpLoader.getParam(string5);
                if (string7 == null) continue;
                string4 = string4 + string7 + " " + string6 + " ";
            }
            if (string2 != null && string2 != "") {
                string4 = string4 + string2;
                if (string3 != null && string3 != "") {
                    string4 = string4 + ":" + string3;
                }
                stringArray2 = Utilities.split(string4, " ");
                Rdesktop.main(stringArray2);
                dataInputStream.close();
            } else {
                System.err.println("No server name provided");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.err.println("Launch file could not be read: " + iOException.getMessage());
            System.exit(-1);
        }
        catch (OrderException orderException) {
            orderException.printStackTrace();
            System.exit(-1);
        }
        catch (RdesktopException rdesktopException) {
            rdesktopException.printStackTrace();
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getParam(String string) {
        for (int i = 0; i < identifiers.length; ++i) {
            if (!string.equals(identifiers[i])) continue;
            return pairs[i];
        }
        return null;
    }
}

