/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.TextArea;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import net.propero.rdp.Common;
import net.propero.rdp.applet.RdpThread;

public class RdpApplet
extends Applet {
    TextArea aTextArea = null;
    PrintStream aPrintStream = null;
    boolean redirectOutput = false;
    RdpThread rThread = null;

    public void paint(Graphics graphics) {
        graphics.setColor(new Color(0xFFFFFF));
        graphics.fillRect(0, 0, graphics.getClipBounds().width, graphics.getClipBounds().height);
        graphics.setColor(new Color(0));
        int n = graphics.getFontMetrics().stringWidth("Launching properJavaRDP session...");
        int n2 = (int)(graphics.getClipBounds().getWidth() / 2.0) - n / 2;
        int n3 = (int)(graphics.getClipBounds().getHeight() / 2.0);
        if (!this.redirectOutput) {
            graphics.drawString("Launching properJavaRDP session...", n2, n3);
        }
        n = graphics.getFontMetrics().stringWidth("Connect to:" + this.getParameter("server"));
        n2 = (int)(graphics.getClipBounds().getWidth() / 2.0) - n / 2;
        n3 = (int)(graphics.getClipBounds().getHeight() / 2.0) + 20;
        if (!this.redirectOutput) {
            graphics.drawString("Connecting to:" + this.getParameter("server"), n2, n3);
        }
    }

    public void init() {
        this.redirectOutput = this.isSet("redirectOutput");
        if (this.redirectOutput) {
            this.aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
            System.setOut(this.aPrintStream);
            System.setErr(this.aPrintStream);
            this.aTextArea = new TextArea();
            this.setLayout(new BorderLayout());
            this.add("Center", this.aTextArea);
        }
    }

    public void start() {
        Common.underApplet = true;
        String string = "";
        string = string + this.genParam("-m", "keymap");
        string = string + " " + this.genParam("-u", "username");
        string = string + " " + this.genParam("-p", "password");
        string = string + " " + this.genParam("-n", "hostname");
        string = string + " " + this.genParam("-t", "port");
        string = string + " " + this.genParam("-l", "debug_level");
        string = string + " " + this.genParam("-s", "shell");
        string = string + " " + this.genParam("-t", "title");
        string = string + " " + this.genParam("-c", "command");
        string = string + " " + this.genParam("-d", "domain");
        string = string + " " + this.genParam("-o", "bpp");
        string = string + " " + this.genParam("-g", "geometry");
        string = string + " " + this.genParam("-s", "shell");
        string = string + " " + this.genFlag("--console", "console");
        string = string + " " + this.genFlag("--use_rdp4", "rdp4");
        string = string + " " + this.genFlag("--debug_key", "debug_key");
        string = string + " " + this.genFlag("--debug_hex", "debug_hex");
        string = string + " " + this.genFlag("--no_remap_hash", "no_remap_hash");
        string = string + " " + this.genParam("", "server");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        Object[] objectArray = new Object[]{stringTokenizer, stringArray, new int[]{0}};
        while (((StringTokenizer)objectArray[0]).hasMoreTokens()) {
            int[] nArray = (int[])objectArray[2];
            int n = nArray[0];
            nArray[0] = n + 1;
            ((String[])objectArray[1])[n] = ((StringTokenizer)objectArray[0]).nextToken();
        }
        this.rThread = new RdpThread(stringArray, this.getParameter("redirect_on_exit"), this);
        this.rThread.start();
    }

    public void stop() {
        this.rThread = null;
        this.notify();
    }

    private boolean isSet(String string) {
        String string2 = this.getParameter(string);
        return string2 != null && string2.equalsIgnoreCase("yes");
    }

    private String genFlag(String string, String string2) {
        String string3 = this.getParameter(string2);
        if (string3 != null && string3.equalsIgnoreCase("yes")) {
            return string;
        }
        return "";
    }

    private String genParam(String string, String string2) {
        String string3 = this.getParameter(string2);
        if (string3 != null) {
            if (string != "") {
                return string + " " + string3;
            }
            return string3;
        }
        return "";
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray) throws IOException {
            String string = new String(byArray);
            RdpApplet.this.aTextArea.append(string);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            String string = new String(byArray, n, n2);
            RdpApplet.this.aTextArea.append(string);
        }
    }
}

