/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import net.propero.rdp.Bitmap;
import net.propero.rdp.Cache;
import net.propero.rdp.Common;
import net.propero.rdp.CommunicationMonitor;
import net.propero.rdp.ConnectionException;
import net.propero.rdp.Constants;
import net.propero.rdp.Options;
import net.propero.rdp.OrderException;
import net.propero.rdp.Orders;
import net.propero.rdp.PstCache;
import net.propero.rdp.Rdesktop;
import net.propero.rdp.RdesktopCanvas;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.RdesktopFrame;
import net.propero.rdp.RdpPacket_Localised;
import net.propero.rdp.Secure;
import net.propero.rdp.crypto.CryptoException;
import net.propero.rdp.rdp5.VChannels;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class Rdp {
    public static int RDP5_DISABLE_NOTHING = 0;
    public static int RDP5_NO_WALLPAPER = 1;
    public static int RDP5_NO_FULLWINDOWDRAG = 2;
    public static int RDP5_NO_MENUANIMATIONS = 4;
    public static int RDP5_NO_THEMING = 8;
    public static int RDP5_NO_CURSOR_SHADOW = 32;
    public static int RDP5_NO_CURSORSETTINGS = 64;
    protected static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Rdp == null ? (class$net$propero$rdp$Rdp = Rdp.class$("net.propero.rdp.Rdp")) : class$net$propero$rdp$Rdp));
    public static final int RDP_LOGON_NORMAL = 51;
    public static final int RDP_LOGON_AUTO = 8;
    public static final int RDP_LOGON_BLOB = 256;
    private static final int RDP_PDU_DEMAND_ACTIVE = 1;
    private static final int RDP_PDU_CONFIRM_ACTIVE = 3;
    private static final int RDP_PDU_DEACTIVATE = 6;
    private static final int RDP_PDU_DATA = 7;
    private static final int RDP_DATA_PDU_UPDATE = 2;
    private static final int RDP_DATA_PDU_CONTROL = 20;
    private static final int RDP_DATA_PDU_POINTER = 27;
    private static final int RDP_DATA_PDU_INPUT = 28;
    private static final int RDP_DATA_PDU_SYNCHRONISE = 31;
    private static final int RDP_DATA_PDU_BELL = 34;
    private static final int RDP_DATA_PDU_LOGON = 38;
    private static final int RDP_DATA_PDU_FONT2 = 39;
    private static final int RDP_DATA_PDU_DISCONNECT = 47;
    private static final int RDP_CTL_REQUEST_CONTROL = 1;
    private static final int RDP_CTL_GRANT_CONTROL = 2;
    private static final int RDP_CTL_DETACH = 3;
    private static final int RDP_CTL_COOPERATE = 4;
    private static final int RDP_UPDATE_ORDERS = 0;
    private static final int RDP_UPDATE_BITMAP = 1;
    private static final int RDP_UPDATE_PALETTE = 2;
    private static final int RDP_UPDATE_SYNCHRONIZE = 3;
    private static final int RDP_POINTER_SYSTEM = 1;
    private static final int RDP_POINTER_MOVE = 3;
    private static final int RDP_POINTER_COLOR = 6;
    private static final int RDP_POINTER_CACHED = 7;
    private static final int RDP_NULL_POINTER = 0;
    private static final int RDP_DEFAULT_POINTER = 32512;
    private static final int RDP_INPUT_SYNCHRONIZE = 0;
    private static final int RDP_INPUT_CODEPOINT = 1;
    private static final int RDP_INPUT_VIRTKEY = 2;
    private static final int RDP_INPUT_SCANCODE = 4;
    private static final int RDP_INPUT_MOUSE = 32769;
    private static final int RDP_CAPSET_GENERAL = 1;
    private static final int RDP_CAPLEN_GENERAL = 24;
    private static final int OS_MAJOR_TYPE_UNIX = 4;
    private static final int OS_MINOR_TYPE_XSERVER = 7;
    private static final int RDP_CAPSET_BITMAP = 2;
    private static final int RDP_CAPLEN_BITMAP = 28;
    private static final int RDP_CAPSET_ORDER = 3;
    private static final int RDP_CAPLEN_ORDER = 88;
    private static final int ORDER_CAP_NEGOTIATE = 2;
    private static final int ORDER_CAP_NOSUPPORT = 4;
    private static final int RDP_CAPSET_BMPCACHE = 4;
    private static final int RDP_CAPLEN_BMPCACHE = 40;
    private static final int RDP_CAPSET_CONTROL = 5;
    private static final int RDP_CAPLEN_CONTROL = 12;
    private static final int RDP_CAPSET_ACTIVATE = 7;
    private static final int RDP_CAPLEN_ACTIVATE = 12;
    private static final int RDP_CAPSET_POINTER = 8;
    private static final int RDP_CAPLEN_POINTER = 8;
    private static final int RDP_CAPSET_SHARE = 9;
    private static final int RDP_CAPLEN_SHARE = 8;
    private static final int RDP_CAPSET_COLCACHE = 10;
    private static final int RDP_CAPLEN_COLCACHE = 8;
    private static final int RDP_CAPSET_UNKNOWN = 13;
    private static final int RDP_CAPLEN_UNKNOWN = 156;
    private static final int RDP_CAPSET_BMPCACHE2 = 19;
    private static final int RDP_CAPLEN_BMPCACHE2 = 40;
    private static final int BMPCACHE2_FLAG_PERSIST = Integer.MIN_VALUE;
    public static final int BMPCACHE2_C0_CELLS = 120;
    public static final int BMPCACHE2_C1_CELLS = 120;
    public static final int BMPCACHE2_C2_CELLS = 336;
    public static final int BMPCACHE2_NUM_PSTCELLS = 2550;
    private static final int RDP5_FLAG = 48;
    private static final byte[] RDP_SOURCE = new byte[]{77, 83, 84, 83, 67, 0};
    protected Secure SecureLayer = null;
    private RdesktopFrame frame = null;
    private RdesktopCanvas surface = null;
    protected Orders orders = null;
    private Cache cache = null;
    private int next_packet = 0;
    private int rdp_shareid = 0;
    private boolean connected = false;
    private RdpPacket_Localised stream = null;
    private final byte[] canned_caps = new byte[]{1, 0, 0, 0, 9, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 8, 0, 1, 0, 0, 0, 14, 0, 8, 0, 1, 0, 0, 0, 16, 0, 52, 0, -2, 0, 4, 0, -2, 0, 4, 0, -2, 0, 8, 0, -2, 0, 8, 0, -2, 0, 16, 0, -2, 0, 32, 0, -2, 0, 64, 0, -2, 0, -128, 0, -2, 0, 0, 1, 64, 0, 0, 8, 0, 1, 0, 1, 2, 0, 0, 0};
    static byte[] caps_0x0d = new byte[]{1, 0, 0, 0, 9, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static byte[] caps_0x0c = new byte[]{1, 0, 0, 0};
    static byte[] caps_0x0e = new byte[]{1, 0, 0, 0};
    static byte[] caps_0x10 = new byte[]{-2, 0, 4, 0, -2, 0, 4, 0, -2, 0, 8, 0, -2, 0, 8, 0, -2, 0, 16, 0, -2, 0, 32, 0, -2, 0, 64, 0, -2, 0, -128, 0, -2, 0, 0, 1, 64, 0, 0, 8, 0, 1, 0, 1, 2, 0, 0, 0};
    boolean deactivated;
    int ext_disc_reason;
    static /* synthetic */ Class class$net$propero$rdp$Rdp;

    static void processGeneralCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.incrementPosition(10);
        int n = rdpPacket_Localised.getLittleEndian16();
        if (n != 0) {
            Options.use_rdp5 = false;
        }
    }

    static void processBitmapCaps(RdpPacket_Localised rdpPacket_Localised) {
        int n = rdpPacket_Localised.getLittleEndian16();
        rdpPacket_Localised.incrementPosition(6);
        int n2 = rdpPacket_Localised.getLittleEndian16();
        int n3 = rdpPacket_Localised.getLittleEndian16();
        logger.debug((Object)("setting desktop size and bpp to: " + n2 + "x" + n3 + "x" + n));
        if (Options.server_bpp != n) {
            logger.warn((Object)("colour depth changed from " + Options.server_bpp + " to " + n));
            Options.server_bpp = n;
        }
        if (Options.width != n2 || Options.height != n3) {
            logger.warn((Object)("screen size changed from " + Options.width + "x" + Options.height + " to " + n2 + "x" + n3));
            Options.width = n2;
            Options.height = n3;
        }
    }

    void processServerCaps(RdpPacket_Localised rdpPacket_Localised, int n) {
        int n2 = rdpPacket_Localised.getPosition();
        int n3 = rdpPacket_Localised.getLittleEndian16();
        rdpPacket_Localised.incrementPosition(2);
        for (int i = 0; i < n3; ++i) {
            if (rdpPacket_Localised.getPosition() > n2 + n) {
                return;
            }
            int n4 = rdpPacket_Localised.getLittleEndian16();
            int n5 = rdpPacket_Localised.getLittleEndian16();
            int n6 = rdpPacket_Localised.getPosition() + n5 - 4;
            switch (n4) {
                case 1: {
                    Rdp.processGeneralCaps(rdpPacket_Localised);
                    break;
                }
                case 2: {
                    Rdp.processBitmapCaps(rdpPacket_Localised);
                }
            }
            rdpPacket_Localised.setPosition(n6);
        }
    }

    protected int processDisconnectPdu(RdpPacket_Localised rdpPacket_Localised) {
        logger.debug((Object)"Received disconnect PDU");
        return rdpPacket_Localised.getLittleEndian32();
    }

    public Rdp(VChannels vChannels) {
        Common.secure = this.SecureLayer = new Secure(vChannels);
        this.orders = new Orders();
        this.cache = new Cache();
        this.orders.registerCache(this.cache);
    }

    private RdpPacket_Localised initData(int n) throws RdesktopException {
        RdpPacket_Localised rdpPacket_Localised = null;
        rdpPacket_Localised = this.SecureLayer.init(Constants.encryption ? 8 : 0, n + 18);
        rdpPacket_Localised.pushLayer(3, 18);
        return rdpPacket_Localised;
    }

    private void sendData(RdpPacket_Localised rdpPacket_Localised, int n) throws RdesktopException, IOException, CryptoException {
        CommunicationMonitor.lock(this);
        rdpPacket_Localised.setPosition(rdpPacket_Localised.getHeader(3));
        int n2 = rdpPacket_Localised.getEnd() - rdpPacket_Localised.getPosition();
        rdpPacket_Localised.setLittleEndian16(n2);
        rdpPacket_Localised.setLittleEndian16(23);
        rdpPacket_Localised.setLittleEndian16(this.SecureLayer.getUserID() + 1001);
        rdpPacket_Localised.setLittleEndian32(this.rdp_shareid);
        rdpPacket_Localised.set8(0);
        rdpPacket_Localised.set8(1);
        rdpPacket_Localised.setLittleEndian16(n2 - 14);
        rdpPacket_Localised.set8(n);
        rdpPacket_Localised.set8(0);
        rdpPacket_Localised.setLittleEndian16(0);
        this.SecureLayer.send(rdpPacket_Localised, Constants.encryption ? 8 : 0);
        CommunicationMonitor.unlock(this);
    }

    private RdpPacket_Localised receive(int[] nArray) throws IOException, RdesktopException, CryptoException, OrderException {
        int n = 0;
        if (this.stream == null || this.next_packet >= this.stream.getEnd()) {
            this.stream = this.SecureLayer.receive();
            if (this.stream == null) {
                return null;
            }
            this.next_packet = this.stream.getPosition();
        } else {
            this.stream.setPosition(this.next_packet);
        }
        n = this.stream.getLittleEndian16();
        if (n == 32768) {
            logger.warn((Object)"32k packet keepalive fix");
            this.next_packet += 8;
            nArray[0] = 0;
            return this.stream;
        }
        nArray[0] = this.stream.getLittleEndian16() & 0xF;
        if (this.stream.getPosition() != this.stream.getEnd()) {
            this.stream.incrementPosition(2);
        }
        this.next_packet += n;
        return this.stream;
    }

    public void connect(String string, InetAddress inetAddress, int n, String string2, String string3, String string4, String string5) throws ConnectionException {
        try {
            this.SecureLayer.connect(inetAddress);
            this.connected = true;
            this.sendLogonInfo(n, string2, string, string3, string4, string5);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectionException("Could not resolve host name: " + inetAddress);
        }
        catch (ConnectException connectException) {
            throw new ConnectionException("Connection refused when trying to connect to " + inetAddress + " on port " + Options.port);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            throw new ConnectionException("Connection timed out when attempting to connect to " + inetAddress);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Connection Failed");
        }
        catch (RdesktopException rdesktopException) {
            throw new ConnectionException(rdesktopException.getMessage());
        }
        catch (OrderException orderException) {
            throw new ConnectionException(orderException.getMessage());
        }
        catch (CryptoException cryptoException) {
            throw new ConnectionException(cryptoException.getMessage());
        }
    }

    public void disconnect() {
        this.connected = false;
        this.SecureLayer.disconnect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void mainLoop(boolean[] blArray, int[] nArray) throws IOException, RdesktopException, OrderException, CryptoException {
        int[] nArray2 = new int[1];
        boolean bl = false;
        boolean bl2 = true;
        RdpPacket_Localised rdpPacket_Localised = null;
        while (bl2) {
            try {
                rdpPacket_Localised = this.receive(nArray2);
                if (rdpPacket_Localised == null) {
                    return;
                }
            }
            catch (EOFException eOFException) {
                return;
            }
            switch (nArray2[0]) {
                case 1: {
                    logger.debug((Object)"Rdp.RDP_PDU_DEMAND_ACTIVE");
                    NDC.push((String)"processDemandActive");
                    this.processDemandActive(rdpPacket_Localised);
                    logger.debug((Object)"ready to send (got past licence negotiation)");
                    Rdesktop.readytosend = true;
                    this.frame.triggerReadyToSend();
                    NDC.pop();
                    blArray[0] = false;
                    break;
                }
                case 6: {
                    blArray[0] = true;
                    this.stream = null;
                    break;
                }
                case 7: {
                    logger.debug((Object)"Rdp.RDP_PDU_DATA");
                    NDC.push((String)"processData");
                    bl = this.processData(rdpPacket_Localised, nArray);
                    NDC.pop();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RdesktopException("Unimplemented type in main loop :" + nArray2[0]);
                }
            }
            if (!bl) continue;
            return;
        }
    }

    private void sendLogonInfo(int n, String string, String string2, String string3, String string4, String string5) throws RdesktopException, IOException, CryptoException {
        RdpPacket_Localised rdpPacket_Localised;
        int n2 = 2 * "127.0.0.1".length();
        int n3 = 2 * "C:\\WINNT\\System32\\mstscax.dll".length();
        int n4 = 0;
        int n5 = Constants.encryption ? 72 : 64;
        int n6 = 2 * string.length();
        int n7 = 2 * string2.length();
        int n8 = 2 * string3.length();
        int n9 = 2 * string4.length();
        int n10 = 2 * string5.length();
        if (!Options.use_rdp5 || 1 == Options.server_rdp_version) {
            logger.debug((Object)"Sending RDP4-style Logon packet");
            rdpPacket_Localised = this.SecureLayer.init(n5, 18 + n6 + n7 + n8 + n9 + n10 + 10);
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.setLittleEndian32(n);
            rdpPacket_Localised.setLittleEndian16(n6);
            rdpPacket_Localised.setLittleEndian16(n7);
            rdpPacket_Localised.setLittleEndian16(n8);
            rdpPacket_Localised.setLittleEndian16(n9);
            rdpPacket_Localised.setLittleEndian16(n10);
            rdpPacket_Localised.outUnicodeString(string, n6);
            rdpPacket_Localised.outUnicodeString(string2, n7);
            rdpPacket_Localised.outUnicodeString(string3, n8);
            rdpPacket_Localised.outUnicodeString(string4, n9);
            rdpPacket_Localised.outUnicodeString(string5, n10);
        } else {
            logger.debug((Object)"Sending RDP5-style Logon packet");
            n4 = 12 + (((n |= 0x100) & 8) != 0 ? 2 : 0) + ((n & 0x100) != 0 ? 2 : 0) + 2 + 2 + (0 < n6 ? n6 + 2 : 2) + n7 + ((n & 8) != 0 ? n8 : 0) + 0 + ((n & 0x100) != 0 && (n & 8) == 0 ? 2 : 0) + (0 < n9 ? n9 + 2 : 2) + (0 < n10 ? n10 + 2 : 2) + 2 + 2 + n2 + 2 + n3 + 2 + 2 + 64 + 20 + 64 + 32 + 6;
            rdpPacket_Localised = this.SecureLayer.init(n5, n4);
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.setLittleEndian32(n);
            rdpPacket_Localised.setLittleEndian16(n6);
            rdpPacket_Localised.setLittleEndian16(n7);
            if ((n & 8) != 0) {
                rdpPacket_Localised.setLittleEndian16(n8);
            }
            if ((n & 0x100) != 0 && (n & 8) == 0) {
                rdpPacket_Localised.setLittleEndian16(0);
            }
            rdpPacket_Localised.setLittleEndian16(n9);
            rdpPacket_Localised.setLittleEndian16(n10);
            if (0 < n6) {
                rdpPacket_Localised.outUnicodeString(string, n6);
            } else {
                rdpPacket_Localised.setLittleEndian16(0);
            }
            rdpPacket_Localised.outUnicodeString(string2, n7);
            if ((n & 8) != 0) {
                rdpPacket_Localised.outUnicodeString(string3, n8);
            }
            if ((n & 0x100) != 0 && (n & 8) == 0) {
                rdpPacket_Localised.setLittleEndian16(0);
            }
            if (0 < n9) {
                rdpPacket_Localised.outUnicodeString(string4, n9);
            } else {
                rdpPacket_Localised.setLittleEndian16(0);
            }
            if (0 < n10) {
                rdpPacket_Localised.outUnicodeString(string5, n10);
            } else {
                rdpPacket_Localised.setLittleEndian16(0);
            }
            rdpPacket_Localised.setLittleEndian16(2);
            rdpPacket_Localised.setLittleEndian16(n2 + 2);
            rdpPacket_Localised.outUnicodeString("127.0.0.1", n2);
            rdpPacket_Localised.setLittleEndian16(n3 + 2);
            rdpPacket_Localised.outUnicodeString("C:\\WINNT\\System32\\mstscax.dll", n3);
            rdpPacket_Localised.setLittleEndian16(65476);
            rdpPacket_Localised.setLittleEndian16(65535);
            rdpPacket_Localised.outUnicodeString("GTB, normaltid", 2 * "GTB, normaltid".length());
            rdpPacket_Localised.incrementPosition(62 - 2 * "GTB, normaltid".length());
            rdpPacket_Localised.setLittleEndian32(655360);
            rdpPacket_Localised.setLittleEndian32(327680);
            rdpPacket_Localised.setLittleEndian32(3);
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.outUnicodeString("GTB, sommartid", 2 * "GTB, sommartid".length());
            rdpPacket_Localised.incrementPosition(62 - 2 * "GTB, sommartid".length());
            rdpPacket_Localised.setLittleEndian32(196608);
            rdpPacket_Localised.setLittleEndian32(327680);
            rdpPacket_Localised.setLittleEndian32(2);
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.setLittleEndian32(-60);
            rdpPacket_Localised.setLittleEndian32(-2);
            rdpPacket_Localised.setLittleEndian32(Options.rdp5_performanceflags);
            rdpPacket_Localised.setLittleEndian32(0);
        }
        rdpPacket_Localised.markEnd();
        byte[] byArray = new byte[rdpPacket_Localised.getEnd()];
        rdpPacket_Localised.copyToByteArray(byArray, 0, 0, rdpPacket_Localised.getEnd());
        this.SecureLayer.send(rdpPacket_Localised, n5);
    }

    private void processDemandActive(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException, IOException, CryptoException, OrderException {
        int[] nArray = new int[1];
        this.rdp_shareid = rdpPacket_Localised.getLittleEndian32();
        this.sendConfirmActive();
        this.sendSynchronize();
        this.sendControl(4);
        this.sendControl(1);
        this.receive(nArray);
        this.receive(nArray);
        this.receive(nArray);
        this.sendInput(0, 0, 0, 0, 0);
        this.sendFonts(1);
        this.sendFonts(2);
        this.receive(nArray);
        this.orders.resetOrderState();
    }

    private boolean processData(RdpPacket_Localised rdpPacket_Localised, int[] nArray) throws RdesktopException, OrderException {
        int n = 0;
        rdpPacket_Localised.incrementPosition(6);
        int n2 = rdpPacket_Localised.getLittleEndian16();
        n = rdpPacket_Localised.get8();
        int n3 = rdpPacket_Localised.get8();
        int n4 = rdpPacket_Localised.getLittleEndian16();
        n4 -= 18;
        switch (n) {
            case 2: {
                logger.debug((Object)"Rdp.RDP_DATA_PDU_UPDATE");
                this.processUpdate(rdpPacket_Localised);
                break;
            }
            case 20: {
                logger.debug((Object)"Received Control PDU\n");
                break;
            }
            case 31: {
                logger.debug((Object)"Received Sync PDU\n");
                break;
            }
            case 27: {
                logger.debug((Object)"Received pointer PDU");
                this.processPointer(rdpPacket_Localised);
                break;
            }
            case 34: {
                logger.debug((Object)"Received bell PDU");
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.beep();
                break;
            }
            case 38: {
                logger.debug((Object)"User logged on");
                Rdesktop.loggedon = true;
                break;
            }
            case 47: {
                nArray[0] = this.processDisconnectPdu(rdpPacket_Localised);
                logger.debug((Object)"Received disconnect PDU\n");
                return true;
            }
            default: {
                logger.warn((Object)("Unimplemented Data PDU type " + n));
            }
        }
        return false;
    }

    private void processUpdate(RdpPacket_Localised rdpPacket_Localised) throws OrderException, RdesktopException {
        int n = 0;
        n = rdpPacket_Localised.getLittleEndian16();
        switch (n) {
            case 0: {
                rdpPacket_Localised.incrementPosition(2);
                int n2 = rdpPacket_Localised.getLittleEndian16();
                rdpPacket_Localised.incrementPosition(2);
                this.orders.processOrders(rdpPacket_Localised, this.next_packet, n2);
                break;
            }
            case 1: {
                this.processBitmapUpdates(rdpPacket_Localised);
                break;
            }
            case 2: {
                this.processPalette(rdpPacket_Localised);
                break;
            }
            case 3: {
                break;
            }
            default: {
                logger.warn((Object)("Unimplemented Update type " + n));
            }
        }
    }

    private void sendConfirmActive() throws RdesktopException, IOException, CryptoException {
        int n = 388;
        int n2 = Options.encryption ? 56 : 48;
        RdpPacket_Localised rdpPacket_Localised = this.SecureLayer.init(n2, 20 + n + RDP_SOURCE.length);
        rdpPacket_Localised.setLittleEndian16(16 + n + RDP_SOURCE.length);
        rdpPacket_Localised.setLittleEndian16(19);
        rdpPacket_Localised.setLittleEndian16(Common.mcs.getUserID() + 1001);
        rdpPacket_Localised.setLittleEndian32(this.rdp_shareid);
        rdpPacket_Localised.setLittleEndian16(1002);
        rdpPacket_Localised.setLittleEndian16(RDP_SOURCE.length);
        rdpPacket_Localised.setLittleEndian16(n);
        rdpPacket_Localised.copyFromByteArray(RDP_SOURCE, 0, rdpPacket_Localised.getPosition(), RDP_SOURCE.length);
        rdpPacket_Localised.incrementPosition(RDP_SOURCE.length);
        rdpPacket_Localised.setLittleEndian16(13);
        rdpPacket_Localised.incrementPosition(2);
        this.sendGeneralCaps(rdpPacket_Localised);
        this.sendBitmapCaps(rdpPacket_Localised);
        this.sendOrderCaps(rdpPacket_Localised);
        if (Options.use_rdp5 && Options.persistent_bitmap_caching) {
            logger.info((Object)"Persistent caching enabled");
            this.sendBitmapcache2Caps(rdpPacket_Localised);
        } else {
            this.sendBitmapcacheCaps(rdpPacket_Localised);
        }
        this.sendColorcacheCaps(rdpPacket_Localised);
        this.sendActivateCaps(rdpPacket_Localised);
        this.sendControlCaps(rdpPacket_Localised);
        this.sendPointerCaps(rdpPacket_Localised);
        this.sendShareCaps(rdpPacket_Localised);
        this.sendUnknownCaps(rdpPacket_Localised, 13, 88, caps_0x0d);
        this.sendUnknownCaps(rdpPacket_Localised, 12, 8, caps_0x0c);
        this.sendUnknownCaps(rdpPacket_Localised, 14, 8, caps_0x0e);
        this.sendUnknownCaps(rdpPacket_Localised, 16, 52, caps_0x10);
        rdpPacket_Localised.markEnd();
        logger.debug((Object)"confirm active");
        Common.secure.send(rdpPacket_Localised, n2);
    }

    private void sendGeneralCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(24);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(3);
        rdpPacket_Localised.setLittleEndian16(512);
        rdpPacket_Localised.setLittleEndian16(Options.use_rdp5 ? 1037 : 0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
    }

    private void sendBitmapCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(2);
        rdpPacket_Localised.setLittleEndian16(28);
        rdpPacket_Localised.setLittleEndian16(Options.server_bpp);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(Options.width);
        rdpPacket_Localised.setLittleEndian16(Options.height);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(Options.bitmap_compression ? 1 : 0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(0);
    }

    private void sendOrderCaps(RdpPacket_Localised rdpPacket_Localised) {
        byte[] byArray = new byte[32];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = (byte)(Options.bitmap_caching ? 1 : 0);
        byArray[4] = 0;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[20] = (byte)(Options.polygon_ellipse_orders ? 1 : 0);
        byArray[21] = (byte)(Options.polygon_ellipse_orders ? 1 : 0);
        byArray[22] = 1;
        byArray[25] = (byte)(Options.polygon_ellipse_orders ? 1 : 0);
        byArray[26] = (byte)(Options.polygon_ellipse_orders ? 1 : 0);
        byArray[27] = 1;
        rdpPacket_Localised.setLittleEndian16(3);
        rdpPacket_Localised.setLittleEndian16(88);
        rdpPacket_Localised.incrementPosition(20);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(20);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(327);
        rdpPacket_Localised.setLittleEndian16(42);
        rdpPacket_Localised.copyFromByteArray(byArray, 0, rdpPacket_Localised.getPosition(), 32);
        rdpPacket_Localised.incrementPosition(32);
        rdpPacket_Localised.setLittleEndian16(1697);
        rdpPacket_Localised.incrementPosition(6);
        rdpPacket_Localised.setLittleEndian32(230400);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.setLittleEndian32(1252);
    }

    private void sendBitmapcacheCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(4);
        rdpPacket_Localised.setLittleEndian16(40);
        rdpPacket_Localised.incrementPosition(24);
        rdpPacket_Localised.setLittleEndian16(600);
        rdpPacket_Localised.setLittleEndian16(256);
        rdpPacket_Localised.setLittleEndian16(300);
        rdpPacket_Localised.setLittleEndian16(1024);
        rdpPacket_Localised.setLittleEndian16(262);
        rdpPacket_Localised.setLittleEndian16(4096);
    }

    private void sendBitmapcache2Caps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(19);
        rdpPacket_Localised.setLittleEndian16(40);
        rdpPacket_Localised.setLittleEndian16(Options.persistent_bitmap_caching ? 2 : 0);
        rdpPacket_Localised.setBigEndian16(3);
        rdpPacket_Localised.setLittleEndian32(120);
        rdpPacket_Localised.setLittleEndian32(120);
        if (PstCache.pstcache_init(2)) {
            logger.info((Object)"Persistent cache initialized");
            rdpPacket_Localised.setLittleEndian32(-2147481098);
        } else {
            logger.info((Object)"Persistent cache not initialized");
            rdpPacket_Localised.setLittleEndian32(336);
        }
        rdpPacket_Localised.incrementPosition(20);
    }

    private void sendColorcacheCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(10);
        rdpPacket_Localised.setLittleEndian16(8);
        rdpPacket_Localised.setLittleEndian16(6);
        rdpPacket_Localised.setLittleEndian16(0);
    }

    private void sendActivateCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(7);
        rdpPacket_Localised.setLittleEndian16(12);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
    }

    private void sendControlCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(5);
        rdpPacket_Localised.setLittleEndian16(12);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(2);
        rdpPacket_Localised.setLittleEndian16(2);
    }

    private void sendPointerCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(8);
        rdpPacket_Localised.setLittleEndian16(8);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(20);
    }

    private void sendShareCaps(RdpPacket_Localised rdpPacket_Localised) {
        rdpPacket_Localised.setLittleEndian16(9);
        rdpPacket_Localised.setLittleEndian16(8);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(0);
    }

    private void sendUnknownCaps(RdpPacket_Localised rdpPacket_Localised, int n, int n2, byte[] byArray) {
        rdpPacket_Localised.setLittleEndian16(n);
        rdpPacket_Localised.setLittleEndian16(n2);
        rdpPacket_Localised.copyFromByteArray(byArray, 0, rdpPacket_Localised.getPosition(), n2 - 4);
        rdpPacket_Localised.incrementPosition(n2 - 4);
    }

    private void sendSynchronize() throws RdesktopException, IOException, CryptoException {
        RdpPacket_Localised rdpPacket_Localised = this.initData(4);
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(1002);
        rdpPacket_Localised.markEnd();
        logger.debug((Object)"sync");
        this.sendData(rdpPacket_Localised, 31);
    }

    private void sendControl(int n) throws RdesktopException, IOException, CryptoException {
        RdpPacket_Localised rdpPacket_Localised = this.initData(8);
        rdpPacket_Localised.setLittleEndian16(n);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.markEnd();
        logger.debug((Object)"control");
        this.sendData(rdpPacket_Localised, 20);
    }

    public void sendInput(int n, int n2, int n3, int n4, int n5) {
        RdpPacket_Localised rdpPacket_Localised = null;
        try {
            rdpPacket_Localised = this.initData(16);
        }
        catch (RdesktopException rdesktopException) {
            Rdesktop.error(rdesktopException, this, this.frame, false);
        }
        rdpPacket_Localised.setLittleEndian16(1);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian32(n);
        rdpPacket_Localised.setLittleEndian16(n2);
        rdpPacket_Localised.setLittleEndian16(n3);
        rdpPacket_Localised.setLittleEndian16(n4);
        rdpPacket_Localised.setLittleEndian16(n5);
        rdpPacket_Localised.markEnd();
        try {
            this.sendData(rdpPacket_Localised, 28);
        }
        catch (RdesktopException rdesktopException) {
            if (Common.rdp.isConnected()) {
                Rdesktop.error(rdesktopException, Common.rdp, Common.frame, true);
            }
            Common.exit();
        }
        catch (CryptoException cryptoException) {
            if (Common.rdp.isConnected()) {
                Rdesktop.error(cryptoException, Common.rdp, Common.frame, true);
            }
            Common.exit();
        }
        catch (IOException iOException) {
            if (Common.rdp.isConnected()) {
                Rdesktop.error(iOException, Common.rdp, Common.frame, true);
            }
            Common.exit();
        }
    }

    private void sendFonts(int n) throws RdesktopException, IOException, CryptoException {
        RdpPacket_Localised rdpPacket_Localised = this.initData(8);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian16(62);
        rdpPacket_Localised.setLittleEndian16(n);
        rdpPacket_Localised.setLittleEndian16(50);
        rdpPacket_Localised.markEnd();
        logger.debug((Object)"fonts");
        this.sendData(rdpPacket_Localised, 39);
    }

    private void processPointer(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = rdpPacket_Localised.getLittleEndian16();
        rdpPacket_Localised.incrementPosition(2);
        switch (n) {
            case 3: {
                logger.debug((Object)"Rdp.RDP_POINTER_MOVE");
                n2 = rdpPacket_Localised.getLittleEndian16();
                n3 = rdpPacket_Localised.getLittleEndian16();
                if (rdpPacket_Localised.getPosition() > rdpPacket_Localised.getEnd()) break;
                this.surface.movePointer(n2, n3);
                break;
            }
            case 6: {
                this.process_colour_pointer_pdu(rdpPacket_Localised);
                break;
            }
            case 7: {
                this.process_cached_pointer_pdu(rdpPacket_Localised);
                break;
            }
            case 1: {
                this.process_system_pointer_pdu(rdpPacket_Localised);
                break;
            }
        }
    }

    private void process_system_pointer_pdu(RdpPacket_Localised rdpPacket_Localised) {
        int n = 0;
        rdpPacket_Localised.getLittleEndian16(n);
        switch (n) {
            case 0: {
                logger.debug((Object)"RDP_NULL_POINTER");
                this.surface.setCursor(null);
                break;
            }
            default: {
                logger.warn((Object)("Unimplemented system pointer message 0x" + Integer.toHexString(n)));
            }
        }
    }

    protected void processBitmapUpdates(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        byte[] byArray = null;
        int n14 = 0;
        int n15 = 0;
        int n16 = this.surface.getWidth();
        int n17 = this.surface.getHeight();
        n = rdpPacket_Localised.getLittleEndian16();
        for (int i = 0; i < n; ++i) {
            n2 = rdpPacket_Localised.getLittleEndian16();
            n3 = rdpPacket_Localised.getLittleEndian16();
            n4 = rdpPacket_Localised.getLittleEndian16();
            n5 = rdpPacket_Localised.getLittleEndian16();
            n6 = rdpPacket_Localised.getLittleEndian16();
            n7 = rdpPacket_Localised.getLittleEndian16();
            n10 = rdpPacket_Localised.getLittleEndian16();
            int n18 = (n10 + 7) / 8;
            n11 = rdpPacket_Localised.getLittleEndian16();
            n12 = rdpPacket_Localised.getLittleEndian16();
            n8 = n4 - n2 + 1;
            n9 = n5 - n3 + 1;
            if (n16 > n2) {
                n16 = n2;
            }
            if (n17 > n3) {
                n17 = n3;
            }
            if (n15 < n4) {
                n15 = n4;
            }
            if (n14 < n5) {
                n14 = n5;
            }
            if (Options.server_bpp != n10) {
                logger.warn((Object)("Server limited colour depth to " + n10 + " bits"));
                Options.set_bpp(n10);
            }
            if (n11 == 0) {
                byArray = new byte[n6 * n7 * n18];
                for (int j = 0; j < n7; ++j) {
                    rdpPacket_Localised.copyToByteArray(byArray, (n7 - j - 1) * (n6 * n18), rdpPacket_Localised.getPosition(), n6 * n18);
                    rdpPacket_Localised.incrementPosition(n6 * n18);
                }
                this.surface.displayImage(Bitmap.convertImage(byArray, n18), n6, n7, n2, n3, n8, n9);
                continue;
            }
            if ((n11 & 0x400) != 0) {
                n13 = n12;
            } else {
                rdpPacket_Localised.incrementPosition(2);
                n13 = rdpPacket_Localised.getLittleEndian16();
                rdpPacket_Localised.incrementPosition(4);
            }
            if (n18 == 1) {
                byArray = Bitmap.decompress(n6, n7, n13, rdpPacket_Localised, n18);
                if (byArray != null) {
                    this.surface.displayImage(Bitmap.convertImage(byArray, n18), n6, n7, n2, n3, n8, n9);
                    continue;
                }
                logger.warn((Object)"Could not decompress bitmap");
                continue;
            }
            if (Options.bitmap_decompression_store == 2) {
                int[] nArray = Bitmap.decompressInt(n6, n7, n13, rdpPacket_Localised, n18);
                if (nArray != null) {
                    this.surface.displayImage(nArray, n6, n7, n2, n3, n8, n9);
                    continue;
                }
                logger.warn((Object)"Could not decompress bitmap");
                continue;
            }
            if (Options.bitmap_decompression_store == 1) {
                Image image = Bitmap.decompressImg(n6, n7, n13, rdpPacket_Localised, n18, null);
                if (image != null) {
                    this.surface.displayImage(image, n2, n3);
                    continue;
                }
                logger.warn((Object)"Could not decompress bitmap");
                continue;
            }
            this.surface.displayCompressed(n2, n3, n6, n7, n13, rdpPacket_Localised, n18, null);
        }
        this.surface.repaint(n16, n17, n15 - n16 + 1, n14 - n17 + 1);
    }

    protected void processPalette(RdpPacket_Localised rdpPacket_Localised) {
        int n = 0;
        IndexColorModel indexColorModel = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n2 = 0;
        rdpPacket_Localised.incrementPosition(2);
        n = rdpPacket_Localised.getLittleEndian16();
        rdpPacket_Localised.incrementPosition(2);
        byArray = new byte[n * 3];
        byArray2 = new byte[n];
        byArray3 = new byte[n];
        byArray4 = new byte[n];
        rdpPacket_Localised.copyToByteArray(byArray, 0, rdpPacket_Localised.getPosition(), byArray.length);
        rdpPacket_Localised.incrementPosition(byArray.length);
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[n2];
            byArray3[i] = byArray[n2 + 1];
            byArray4[i] = byArray[n2 + 2];
            n2 += 3;
        }
        indexColorModel = new IndexColorModel(8, n, byArray2, byArray3, byArray4);
        this.surface.registerPalette(indexColorModel);
    }

    public void registerDrawingSurface(RdesktopFrame rdesktopFrame) {
        RdesktopCanvas rdesktopCanvas;
        this.frame = rdesktopFrame;
        this.surface = rdesktopCanvas = rdesktopFrame.getCanvas();
        this.orders.registerDrawingSurface(rdesktopCanvas);
    }

    protected void process_null_system_pointer_pdu(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        this.surface.setCursor(this.cache.getCursor(0));
    }

    protected void process_colour_pointer_pdu(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        logger.debug((Object)"Rdp.RDP_POINTER_COLOR");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Cursor cursor = null;
        n5 = rdpPacket_Localised.getLittleEndian16();
        n = rdpPacket_Localised.getLittleEndian16();
        n2 = rdpPacket_Localised.getLittleEndian16();
        n3 = rdpPacket_Localised.getLittleEndian16();
        n4 = rdpPacket_Localised.getLittleEndian16();
        n6 = rdpPacket_Localised.getLittleEndian16();
        n7 = rdpPacket_Localised.getLittleEndian16();
        byArray = new byte[n6];
        byArray2 = new byte[n7];
        rdpPacket_Localised.copyToByteArray(byArray2, 0, rdpPacket_Localised.getPosition(), n7);
        rdpPacket_Localised.incrementPosition(n7);
        rdpPacket_Localised.copyToByteArray(byArray, 0, rdpPacket_Localised.getPosition(), n6);
        rdpPacket_Localised.incrementPosition(n6);
        cursor = this.surface.createCursor(n, n2, n3, n4, byArray, byArray2, n5);
        this.surface.setCursor(cursor);
        this.cache.putCursor(n5, cursor);
    }

    protected void process_cached_pointer_pdu(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        logger.debug((Object)"Rdp.RDP_POINTER_CACHED");
        int n = rdpPacket_Localised.getLittleEndian16();
        this.surface.setCursor(this.cache.getCursor(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

