/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.propero.rdp.Common;
import net.propero.rdp.Constants;
import net.propero.rdp.Options;
import net.propero.rdp.Rdesktop;
import net.propero.rdp.RdesktopCanvas;
import net.propero.rdp.RdesktopCanvas_Localised;
import net.propero.rdp.Rdp;
import net.propero.rdp.keymapping.KeyCode_FileBased;
import net.propero.rdp.menu.RdpMenu;
import net.propero.rdp.rdp5.cliprdr.ClipChannel;
import org.apache.log4j.Logger;

public abstract class RdesktopFrame
extends Frame {
    static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$RdesktopFrame == null ? (class$net$propero$rdp$RdesktopFrame = RdesktopFrame.class$("net.propero.rdp.RdesktopFrame")) : class$net$propero$rdp$RdesktopFrame));
    public RdesktopCanvas canvas = null;
    public Rdp rdp = null;
    public RdpMenu menu = null;
    protected boolean inFullscreen = false;
    private boolean menuVisible = false;
    static /* synthetic */ Class class$net$propero$rdp$RdesktopFrame;

    public void setClip(ClipChannel clipChannel) {
        this.canvas.addFocusListener(clipChannel);
    }

    public boolean action(Event event, Object object) {
        if (this.menu != null) {
            return this.menu.action(event, object);
        }
        return false;
    }

    public void goFullScreen() {
        this.inFullscreen = true;
    }

    public void leaveFullScreen() {
        this.inFullscreen = false;
    }

    public void toggleFullScreen() {
        if (this.inFullscreen) {
            this.leaveFullScreen();
        } else {
            this.goFullScreen();
        }
    }

    public void showMenu() {
        if (this.menu == null) {
            this.menu = new RdpMenu(this);
        }
        if (!this.menuVisible && Options.enable_menu) {
            this.setMenuBar(this.menu);
        }
        this.canvas.repaint();
        this.menuVisible = true;
    }

    public void hideMenu() {
        if (this.menuVisible && Options.enable_menu) {
            this.setMenuBar(null);
        }
        this.canvas.repaint();
        this.menuVisible = false;
    }

    public void toggleMenu() {
        if (!this.menuVisible) {
            this.showMenu();
        } else {
            this.hideMenu();
        }
    }

    public RdesktopFrame() {
        Common.frame = this;
        this.canvas = new RdesktopCanvas_Localised(Options.width, Options.height);
        this.add(this.canvas);
        this.setTitle(Options.windowTitle);
        if (Constants.OS == 1) {
            this.setResizable(false);
        }
        if (Options.fullscreen) {
            this.goFullScreen();
            this.pack();
            ((Component)this).setLocation(0, 0);
        } else {
            this.pack();
            this.centreWindow();
        }
        if (Constants.OS != 1) {
            this.setResizable(false);
        }
        this.addWindowListener(new RdesktopWindowAdapter());
        this.canvas.addFocusListener(new RdesktopFocusListener());
        if (Constants.OS == 1) {
            this.addComponentListener(new RdesktopComponentAdapter());
        }
        this.canvas.requestFocus();
    }

    public RdesktopCanvas getCanvas() {
        return this.canvas;
    }

    public void registerCommLayer(Rdp rdp) {
        this.rdp = rdp;
        this.canvas.registerCommLayer(rdp);
    }

    public void registerKeyboard(KeyCode_FileBased keyCode_FileBased) {
        this.canvas.registerKeyboard(keyCode_FileBased);
    }

    public boolean showYesNoErrorDialog(String[] stringArray) {
        YesNoDialog yesNoDialog = new YesNoDialog(this, "properJavaRDP error", stringArray);
        yesNoDialog.show();
        return yesNoDialog.retry;
    }

    public void showErrorDialog(String[] stringArray) {
        OKDialog oKDialog = new OKDialog(this, "properJavaRDP error", stringArray);
        oKDialog.show();
    }

    public void triggerReadyToSend() {
        this.show();
        this.canvas.triggerReadyToSend();
    }

    public void centreWindow(Window window) {
        int n;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        int n2 = (dimension.width - dimension2.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (dimension.height - dimension2.height) / 2) < 0) {
            n = 0;
        }
        ((Component)window).setLocation(n2, n);
    }

    public void centreWindow() {
        this.centreWindow(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OKDialog
    extends Dialog
    implements ActionListener {
        public OKDialog(Frame frame, String string, String[] stringArray) {
            super(frame, string, true);
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(stringArray.length, 1));
            for (int i = 0; i < stringArray.length; ++i) {
                panel.add(new Label(stringArray[i], 1));
            }
            this.add("Center", panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout());
            Button button = new Button("OK");
            button.addActionListener(this);
            panel2.add(button);
            this.add("South", panel2);
            this.pack();
            if (this.getSize().width < 240) {
                ((Component)this).setSize(new Dimension(240, this.getSize().height));
            }
            RdesktopFrame.this.centreWindow(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.hide();
            this.dispose();
        }
    }

    class YesNoDialog
    extends Dialog
    implements ActionListener {
        Button yes;
        Button no;
        boolean retry = false;

        public YesNoDialog(Frame frame, String string, String[] stringArray) {
            super(frame, string, true);
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(stringArray.length, 1));
            for (int i = 0; i < stringArray.length; ++i) {
                panel.add(new Label(stringArray[i], 1));
            }
            this.add("Center", panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout());
            this.yes = new Button("Yes");
            this.yes.addActionListener(this);
            panel2.add(this.yes);
            this.no = new Button("No");
            this.no.addActionListener(this);
            panel2.add(this.no);
            this.add("South", panel2);
            this.pack();
            if (this.getSize().width < 240) {
                ((Component)this).setSize(new Dimension(240, this.getSize().height));
            }
            RdesktopFrame.this.centreWindow(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.retry = actionEvent.getSource() == this.yes;
            this.hide();
            this.dispose();
        }
    }

    class RdesktopComponentAdapter
    extends ComponentAdapter {
        RdesktopComponentAdapter() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            RdesktopFrame.this.canvas.repaint(0, 0, Options.width, Options.height);
        }
    }

    class RdesktopWindowAdapter
    extends WindowAdapter {
        RdesktopWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            RdesktopFrame.this.hide();
            Rdesktop.exit(0, RdesktopFrame.this.rdp, (RdesktopFrame)windowEvent.getWindow(), true);
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            logger.info((Object)"windowLostFocus");
            RdesktopFrame.this.canvas.lostFocus();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            if (Constants.OS == 1) {
                RdesktopFrame.this.canvas.repaint(0, 0, Options.width, Options.height);
            }
            RdesktopFrame.this.canvas.gainedFocus();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (Constants.OS == 1) {
                RdesktopFrame.this.canvas.repaint(0, 0, Options.width, Options.height);
            }
            RdesktopFrame.this.canvas.gainedFocus();
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (Constants.OS == 1) {
                RdesktopFrame.this.canvas.repaint(0, 0, Options.width, Options.height);
            }
            RdesktopFrame.this.canvas.gainedFocus();
        }
    }

    class RdesktopFocusListener
    implements FocusListener {
        RdesktopFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (Constants.OS == 1) {
                RdesktopFrame.this.canvas.repaint(0, 0, Options.width, Options.height);
            }
            RdesktopFrame.this.canvas.gainedFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            RdesktopFrame.this.canvas.lostFocus();
        }
    }
}

