/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.propero.rdp.RdpPacket;

public class RdpPacket_Localised
extends RdpPacket {
    private ByteBuffer bb = null;
    private int size = 0;

    public RdpPacket_Localised(int n) {
        this.bb = ByteBuffer.allocateDirect(n);
        this.size = n;
    }

    public void reset(int n) {
        this.end = 0;
        this.start = 0;
        if (this.bb.capacity() < n) {
            this.bb = ByteBuffer.allocateDirect(n);
        }
        this.size = n;
        this.bb.clear();
    }

    public void set8(int n, int n2) {
        if (n < 0 || n >= this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("memory accessed out of Range!");
        }
        this.bb.put(n, (byte)n2);
    }

    public void set8(int n) {
        if (this.bb.position() >= this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("memory accessed out of Range!");
        }
        this.bb.put((byte)n);
    }

    public int get8(int n) {
        if (n < 0 || n >= this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("memory accessed out of Range!");
        }
        return this.bb.get(n) & 0xFF;
    }

    public int get8() {
        if (this.bb.position() >= this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("memory accessed out of Range!");
        }
        return this.bb.get() & 0xFF;
    }

    public void copyFromByteArray(byte[] byArray, int n, int n2, int n3) {
        if (n >= byArray.length || n + n3 > byArray.length || n2 + n3 > this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("memory accessed out of Range!");
        }
        int n4 = this.getPosition();
        this.setPosition(n2);
        this.bb.put(byArray, n, n3);
        this.setPosition(n4);
    }

    public void copyToByteArray(byte[] byArray, int n, int n2, int n3) {
        if (n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array offset beyond end of array!");
        }
        if (n + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Not enough bytes in array to copy!");
        }
        if (n2 + n3 > this.bb.capacity()) {
            throw new ArrayIndexOutOfBoundsException("Memory accessed out of Range!");
        }
        int n4 = this.getPosition();
        this.setPosition(n2);
        this.bb.get(byArray, n, n3);
        this.setPosition(n4);
    }

    public void copyToPacket(RdpPacket_Localised rdpPacket_Localised, int n, int n2, int n3) {
        int n4 = rdpPacket_Localised.getPosition();
        int n5 = this.getPosition();
        rdpPacket_Localised.setPosition(n2);
        this.setPosition(n);
        for (int i = 0; i < n3; ++i) {
            rdpPacket_Localised.set8(this.bb.get());
        }
        rdpPacket_Localised.setPosition(n4);
        this.setPosition(n5);
    }

    public void copyFromPacket(RdpPacket_Localised rdpPacket_Localised, int n, int n2, int n3) {
        int n4 = rdpPacket_Localised.getPosition();
        int n5 = this.getPosition();
        rdpPacket_Localised.setPosition(n);
        this.setPosition(n2);
        for (int i = 0; i < n3; ++i) {
            this.bb.put((byte)rdpPacket_Localised.get8());
        }
        rdpPacket_Localised.setPosition(n4);
        this.setPosition(n5);
    }

    public int capacity() {
        return this.bb.capacity();
    }

    public int size() {
        return this.size;
    }

    public int getPosition() {
        return this.bb.position();
    }

    public int getLittleEndian16(int n) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort(n);
    }

    public int getLittleEndian16() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort();
    }

    public int getBigEndian16(int n) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort(n);
    }

    public int getBigEndian16() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort();
    }

    public void setLittleEndian16(int n, int n2) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putShort(n, (short)n2);
    }

    public void setLittleEndian16(int n) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putShort((short)n);
    }

    public void setBigEndian16(int n, int n2) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putShort(n, (short)n2);
    }

    public void setBigEndian16(int n) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putShort((short)n);
    }

    public int getLittleEndian32(int n) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getInt(n);
    }

    public int getLittleEndian32() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getInt();
    }

    public int getBigEndian32(int n) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getInt(n);
    }

    public int getBigEndian32() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getInt();
    }

    public void setLittleEndian32(int n, int n2) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putInt(n, n2);
    }

    public void setLittleEndian32(int n) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putInt(n);
    }

    public void setBigEndian32(int n, int n2) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putInt(n, n2);
    }

    public void setBigEndian32(int n) {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putInt(n);
    }

    public void incrementPosition(int n) {
        if (n > this.bb.capacity() || n + this.bb.position() > this.bb.capacity() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bb.position(this.bb.position() + n);
    }

    public void setPosition(int n) {
        if (n > this.bb.capacity() || n < 0) {
            logger.warn((Object)("stream position =" + this.getPosition() + " end =" + this.getEnd() + " capacity =" + this.capacity()));
            logger.warn((Object)("setPosition(" + n + ") failed"));
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bb.position(n);
    }
}

