/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import net.propero.rdp.Constants;
import net.propero.rdp.Input;
import net.propero.rdp.Input_Localised;
import net.propero.rdp.Options;
import net.propero.rdp.Rdesktop;
import net.propero.rdp.RdesktopCanvas;
import net.propero.rdp.Rdp;
import net.propero.rdp.keymapping.KeyCode_FileBased;

public class Input_Localised
extends Input {
    public Input_Localised(RdesktopCanvas rdesktopCanvas, Rdp rdp, KeyCode_FileBased keyCode_FileBased) {
        super(rdesktopCanvas, rdp, keyCode_FileBased);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(0, Collections.EMPTY_SET);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    public Input_Localised(RdesktopCanvas rdesktopCanvas, Rdp rdp, String string) {
        super(rdesktopCanvas, rdp, string);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(0, Collections.EMPTY_SET);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    public void clearKeys() {
        super.clearKeys();
        if (this.lastKeyEvent != null && this.lastKeyEvent.isAltGraphDown()) {
            this.sendScancode(Input_Localised.getTime(), 49152, 184);
        }
    }

    public void setKeys() {
        super.setKeys();
        if (this.lastKeyEvent != null && this.lastKeyEvent.isAltGraphDown()) {
            this.sendScancode(Input_Localised.getTime(), 0, 184);
        }
    }

    protected void doLockKeys() {
        if (!Rdesktop.readytosend) {
            return;
        }
        if (!Options.useLockingKeyState) {
            return;
        }
        if (Constants.OS == 2) {
            return;
        }
        if (Constants.OS == 3) {
            return;
        }
        logger.debug((Object)"doLockKeys");
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit.getLockingKeyState(20) != capsLockOn) {
                capsLockOn = !capsLockOn;
                logger.debug((Object)"CAPS LOCK toggle");
                this.sendScancode(Input_Localised.getTime(), 0, 58);
                this.sendScancode(Input_Localised.getTime(), 49152, 58);
            }
            if (toolkit.getLockingKeyState(144) != numLockOn) {
                numLockOn = !numLockOn;
                logger.debug((Object)"NUM LOCK toggle");
                this.sendScancode(Input_Localised.getTime(), 0, 69);
                this.sendScancode(Input_Localised.getTime(), 49152, 69);
            }
            if (toolkit.getLockingKeyState(145) != scrollLockOn) {
                scrollLockOn = !scrollLockOn;
                logger.debug((Object)"SCROLL LOCK toggle");
                this.sendScancode(Input_Localised.getTime(), 0, 70);
                this.sendScancode(Input_Localised.getTime(), 49152, 70);
            }
        }
        catch (Exception exception) {
            Options.useLockingKeyState = false;
        }
    }

    public void addInputListeners() {
        super.addInputListeners();
        this.canvas.addMouseWheelListener((MouseWheelListener)new RdesktopMouseWheelAdapter(this, null));
    }

    public boolean handleShortcutKeys(long l, KeyEvent keyEvent, boolean bl) {
        if (super.handleShortcutKeys(l, keyEvent, bl)) {
            return true;
        }
        if (!altDown) {
            return false;
        }
        switch (keyEvent.getKeyCode()) {
            case 45: {
                if (!ctrlDown) break;
                if (bl) {
                    this.sendScancode(l, 49152, 29);
                    this.sendScancode(l, 0, 183);
                    logger.debug((Object)"shortcut pressed: sent ALT+PRTSC");
                    break;
                }
                this.sendScancode(l, 49152, 183);
                this.sendScancode(l, 0, 29);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

