/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermCommandTab
extends JPanel
implements SshToolsConnectionTab {
    public static final String COMMANDS_ICON = "/com/sshtools/common/ui/commands.png";
    protected JCheckBox requestPseudoTerminal = new JCheckBox("Don't allocate a pseudo terminal");
    protected JCheckBox disconnectOnSessionClose = new JCheckBox("Disconnect when session is closed");
    protected JLabel onceAuthenticated = new JLabel("Once authenticated..");
    protected JRadioButton doNothing = new JRadioButton("Do nothing");
    protected JRadioButton startShell = new JRadioButton("Start the user's shell");
    protected JRadioButton executeCommands = new JRadioButton("Execute the following commands:");
    protected ButtonGroup group = new ButtonGroup();
    protected JTextArea commands = new JTextArea();
    protected SshToolsConnectionProfile profile;
    protected Log log = LogFactory.getLog(class$com$sshtools$sshterm$SshTermCommandTab == null ? (class$com$sshtools$sshterm$SshTermCommandTab = SshTermCommandTab.class$("com.sshtools.sshterm.SshTermCommandTab")) : class$com$sshtools$sshterm$SshTermCommandTab);
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermCommandTab;

    public SshTermCommandTab() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        Insets insets = new Insets(2, 24, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.requestPseudoTerminal.getModel().setSelected(false);
        this.disconnectOnSessionClose.getModel().setSelected(true);
        UIUtil.jGridBagAdd(jPanel, this.requestPseudoTerminal, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.disconnectOnSessionClose, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, new JSeparator(0), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.onceAuthenticated, gridBagConstraints, 0);
        this.group.add(this.doNothing);
        this.group.add(this.startShell);
        this.group.add(this.executeCommands);
        this.startShell.setSelected(true);
        UIUtil.jGridBagAdd(jPanel, this.doNothing, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.startShell, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.executeCommands, gridBagConstraints, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 1.0;
        this.commands.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane = new JScrollPane(this.commands);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        UIUtil.jGridBagAdd(jPanel, jScrollPane, gridBagConstraints, 0);
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(COMMANDS_ICON), jPanel);
        this.commands.setRows(8);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)iconWrapperPanel, "North");
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
        this.requestPseudoTerminal.getModel().setSelected(!sshToolsConnectionProfile.requiresPseudoTerminal());
        this.disconnectOnSessionClose.getModel().setSelected(sshToolsConnectionProfile.disconnectOnSessionClose());
        if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() == 1) {
            this.doNothing.setSelected(true);
        } else if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() == 3) {
            this.executeCommands.setSelected(true);
            this.commands.setText(sshToolsConnectionProfile.getCommandsToExecute());
        } else {
            this.startShell.setSelected(true);
        }
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Commands";
    }

    public String getTabToolTipText() {
        return "Configure the commands to be executed";
    }

    public int getTabMnemonic() {
        return 112;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        this.profile.setRequiresPseudoTerminal(!this.requestPseudoTerminal.getModel().isSelected());
        if (!this.doNothing.isSelected()) {
            this.profile.setDisconnectOnSessionClose(this.disconnectOnSessionClose.getModel().isSelected());
        } else {
            this.profile.setDisconnectOnSessionClose(false);
        }
        if (this.doNothing.isSelected()) {
            this.profile.setOnceAuthenticatedCommand(1);
        } else if (this.executeCommands.isSelected()) {
            this.profile.setOnceAuthenticatedCommand(3);
            this.profile.setCommandsToExecute(this.commands.getText());
        } else {
            this.profile.setOnceAuthenticatedCommand(2);
        }
    }

    public void tabSelected() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

