/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ResourceIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private ResourceIcon icon;
    private boolean alignBottomRight = false;

    public ImagePanel(String string) {
        this.icon = new ResourceIcon(string);
    }

    public ImagePanel(ResourceIcon resourceIcon, int n) {
        this.icon = resourceIcon;
        this.alignBottomRight = true;
    }

    public ImagePanel(String string, int n) {
        this.icon = new ResourceIcon(string);
        this.alignBottomRight = true;
    }

    public ImagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Dimension getPreferedSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.icon.getIconWidth() + insets.left + insets.right, this.icon.getIconHeight() + insets.top + insets.bottom);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.icon != null) {
            Insets insets = this.getInsets();
            if (!this.alignBottomRight) {
                this.icon.paintIcon(this, graphics, insets.left, insets.top);
            } else {
                this.icon.paintIcon(this, graphics, this.getWidth() - this.icon.getIconWidth(), this.getHeight() - this.icon.getIconHeight());
            }
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
    }
}

